﻿<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN"
        "http://www.w3.org/TR/html4/strict.dtd">
<html lang="sv">
	<head>
		<meta http-equiv="content-type" content="text/html; charset=utf-8">
		<title>
			PDF examples for Lasso Summit 2007 
		</title>
<style type="text/css" title="text/css">
<!--
html	{
	font-size: 125%;

	}

body {
 	font-family: verdana;
 	font-size: 75%;
 	padding: 0;
 	border: 0;
 	margin: 0;
	}

#container {
	position:relative;
	}

#head {
	color:darkgrey;
	position:absolute;
	top:20px;
	left:50px;
	margin-right:80px;
	}

#head img {
	float:left;
	}
#content {
	left:50px;
	min-width: 540px;
	max-width: 800px;
 	font-size: 0.9em;
	color:black;
	position:absolute;
	top:220px;
	margin-right:80px;
	}

h1{
	font-size: 1.9em;
	}
h2{
	font-size: 1.3em;
	text-indent:3%;
	margin-bottom:-0.8em;
	}

.demos {
	margin:0px 25px 3px 35px;
	}

-->
</style> 
	</head>
	<body>
		<div id="container">
			<div id="head">
				<img src="ex_cont/summit07bannerSmall.jpg">
				<h1>
					Examples on how to make use of the PDF tag suite available in Lasso 8.5. 
				</h1>
			</div>
<!-- end head -->
			<div id="content">
				<div id="intro">
					<p>
						The examples are put together by Jolle Carlestam for the Lasso Summit 2007. Parts of code is inspired by TOTW or Lasso Talk discussions. 
						<br />
						Use and abuse as you wish. Please keep information regarding origin in the pages. 
					</p>
					<p>
						The demos depends on some external files. Some of the files act as substitutes for DB calls and contain demo data. Some are pdf templates needed. The files are located in the folder ex_cont. This needs to be in the same folder as the demo files. Lasso must be configured to handle files with the suffix .incl and to be able to include pdf files. 
					</p>
					<p>
						Lund jan 15 2007 
						<br />
						Jolle Carlestam 
					</p>
				</div>
<!-- end intro -->
				<div id="labelDemo" class="demos">
					<h2>
						Mailing Labels 
					</h2>
					<p>
						Mimics Filemaker feature by allowing vertical adjustment of the label content. Handles multi page. Demo settings are suitable for an A4 page with Avery 7160 labels using 3 cols 7 rows per page. 
						<br />
						Inspired by a TOTW example by Fletcher Sandbeck from 2004. 
					</p>
					<p>
						<a href="label.lasso" title="Create a pdf with Mailing Labels">
							Mailing Labels PDF 
						</a>
					</p>
				</div>
<!-- end labelDemo -->
				<div id="nametagDemo" class="demos">
					<h2>
						Nametags with style 
					</h2>
					<p>
						Built on the mailing label code. Allows an image used as background. Settings are suitable for an A4 page. 
					</p>
					<p>
						<a href="nametag.lasso" title="Create a pdf with Nametags">
							Nametags with style PDF 
						</a>
					</p>
				</div>
<!-- end nametagDemo -->
				<div id="listDemo" class="demos">
					<h2>
						List of contacts 
					</h2>
					<p>
						Multi page, multi column list of contacts with room for multiple addresses and multiple phone, e-mail, web, fax items. Settings are suitable for an A4 page. 
					</p>
					<p>
						<a href="list.lasso" title="Create a pdf with a list of contacts">
							List of contacts PDF 
						</a>
					</p>
				</div>
<!-- end listDemo -->
				<div id="invoiceDemo" class="demos">
					<h2>
						Invoice 
					</h2>
					<p>
						Invoice using a layout following a corporations graphical guide lines. Allowing multiple lines of information for each item and multiple pages should items not fit on first page. Summaries are kept on first page. 
					</p>
					<p>
						<a href="invoice.lasso?invData=Invoice1.incl" title="Create a pdf with an invoice, example 1">
							Invoice - example one page - PDF 
						</a>
						<br />
						<a href="invoice.lasso?invData=Invoice2.incl" title="Create a pdf with an invoice, example 2">
							Invoice - example two pages - PDF 
						</a>
					</p>
				</div>
<!-- end invoiceDemo -->
				<div id="leafletDemo" class="demos">
					<h2>
						Multi-column info leaflet 
					</h2>
					<p>
						Using dynamic data to build a styled leaflet. Allows users to download a pdf with dynamically created content. Handles images of varying size and orientation and adjust text content to flow around the image. 
					</p>
					<p>
						<a href="leaflet.lasso" title="Create a pdf with a multi-column info leaflet">
							Multi-column info leaflet PDF 
						</a>
					</p>
				</div>
<!-- end leafletDemo -->
			</div>
<!-- end content -->
		</div>
<!-- end container -->
	</body>
</html>
